
USE BD_Air_France;

IF OBJECT_ID ('dbo.T_Pilote_pil','U') IS NOT NULL
    DROP TABLE dbo.T_Pilote_pil;
GO

CREATE TABLE T_Pilote_pil
(pil_brevet VARCHAR(6),
 pil_nom    VARCHAR(20), pil_nbHVol DECIMAL(7,2), cmp_comp VARCHAR(4),
 CONSTRAINT pk_Pilote PRIMARY KEY(pil_brevet));

INSERT INTO T_Pilote_pil VALUES ('PL-1', 'Giaconne', 2450, 'AF');
INSERT INTO T_Pilote_pil VALUES ('PL-2', 'Bardon', 900, 'AF');
INSERT INTO T_Pilote_pil VALUES ('PL-3', 'Mejers', 2500, 'SING');
INSERT INTO T_Pilote_pil VALUES ('PL-4', 'Lhospice', 5500, 'CAST');
INSERT INTO T_Pilote_pil VALUES ('PL-5', 'Calac', 5400, 'AF');
INSERT INTO T_Pilote_pil VALUES ('PL-6', 'Cogne', 2500, 'SING');
GO

-- 307, 7-20

CREATE FUNCTION F_EffectifsHeure
(@p1 VARCHAR(4), @p2 DECIMAL(7,2)) 
RETURNS SMALLINT
WITH SCHEMABINDING,
CALLED ON NULL INPUT
AS 
BEGIN
DECLARE @res SMALLINT = 0;
IF (@p1 IS NULL)
  SELECT @res=COUNT(*) FROM dbo.T_Pilote_pil WHERE pil_nbHVol>@p2;
 ELSE
  SELECT @res=COUNT(*) FROM dbo.T_Pilote_pil WHERE pil_nbHVol>@p2 AND cmp_comp=@p1;
RETURN @res;
END;
GO

--  Appels 

SELECT DISTINCT cmp_comp, 2450 AS Heures,
       dbo.F_EffectifsHeure(cmp_comp,2450) AS Nombre
FROM   T_Pilote_pil
ORDER BY Nombre DESC, cmp_comp DESC;

DECLARE @res    SMALLINT;
DECLARE @comp   VARCHAR(4) = 'AF';
DECLARE @heures DECIMAL(7,2) = 1300.00;
BEGIN 
 SET @res = dbo.F_EffectifsHeure(@comp,@heures);
END;
PRINT 'Nombre de pilotes de AF dpassant 1300 hdv : '+CAST(@res AS VARCHAR(4));

--


CREATE FUNCTION F_MAX2 (@VAL1 sql_variant, @VAL2 sql_variant)
RETURNS sql_variant
AS
BEGIN
   RETURN CASE 
             WHEN @VAL1 > @VAL2
                THEN @VAL1
             WHEN @VAL2 IS NULL
                THEN @VAL1
             ELSE @VAL2
          END;
END;



-- 308, 7-23

CREATE FUNCTION F_T_MoyHeure() 
RETURNS TABLE
AS RETURN (SELECT cmp_comp, AVG(pil_nbhvol) AS moyenne
           FROM dbo.T_Pilote_pil GROUP BY cmp_comp);
GO

CREATE FUNCTION F_T_MaxHeure() 
RETURNS @table_res TABLE 
(compagnie VARCHAR(4) PRIMARY KEY,
 max_heure DECIMAL(7,2))
AS BEGIN
  INSERT INTO @table_res
  SELECT cmp_comp, MAX(pil_nbhvol) AS maxi
         FROM dbo.T_Pilote_pil GROUP BY cmp_comp;
  RETURN;
END;
GO

-- 309, 7-24

CREATE TYPE tab_res_t AS TABLE 
   (compagnie VARCHAR(4),
    moyenne_heure DECIMAL(7,2),
    PRIMARY KEY(compagnie)) ;
GO
DECLARE @table_res tab_res_t ;
INSERT INTO @table_res 
        SELECT * FROM dbo.F_T_MoyHeure() ;

CREATE TYPE tab_t AS TABLE 
   (c1 VARCHAR(4) PRIMARY KEY,
    c2 DECIMAL(7,2)) ;
GO
DECLARE @tab tab_t;
INSERT INTO @tab SELECT * FROM dbo.F_T_MaxHeure();
SELECT * FROM @tab;

DROP TYPE tab_t;
GO

DROP TYPE tab_res_t;
GO

DROP FUNCTION F_EffectifsHeure;
GO

DROP FUNCTION F_T_MoyHeure;
GO

DROP FUNCTION F_T_MaxHeure;
GO

DROP TABLE T_Pilote_pil;
GO
